#include "hbcompat.ch"
#include "tdolphin.ch"
#include "xbrowse.ch"
#include "fivewin.ch"

FUNCTION Main() 

   LOCAL oWnd 
   LOCAL oMenu
   LOCAL oServer
   MENU oMenu 2007
      MENUITEM "testing" ACTION DataBrowse( oServer, oWnd )
   ENDMENU
   
   SET CENTURY ON
   SET DATE FORMAT "dd/mm/yyyy"   
      
   //Activated Case sensitive
   D_SetCaseSensitive( .T. )
   
   IF ( oServer := ConnectTo() ) == NIL
      RETURN NIL
   ENDIF
   oServer:bDebug = {| cQry | LogFile( "debug.txt", { cQry } ) }
   
   DEFINE WINDOW oWnd TITLE "Testing Dolphin - Fivewin" MENU oMenu
   
   ACTIVATE WINDOW oWnd 
   
   oServer:End()
   
RETURN NIL

PROCEDURE DataBrowse( oServer, oWnd )

   LOCAL oQry 
   LOCAL oDlg
   LOCAL oBrw
   LOCAL oData, oCol
   LOCAL lNew := .F.
   LOCAL lMod := .F.
   LOCAL oBtnSave
   
   
   oQry = oServer:Query( "SELECT * FROM copy ORDER BY last_name" )
   
   oData = oQry
   
   DEFINE DIALOG oDlg RESOURCE "DATAS" OF oWnd
   
   REDEFINE GET oData:last_name ID 4008 OF oDlg   UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:first_name ID 4009 OF oDlg  UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:suffix ID 4010 OF oDlg      UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:city ID 4011 OF oDlg        UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:state ID 4012 OF oDlg       UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:birth ID 4013 OF oDlg       UPDATE WHEN lNew .OR. lMod
   REDEFINE GET oData:death ID 4014 OF oDlg       UPDATE WHEN lNew .OR. lMod
                                                 
   REDEFINE BUTTON ID 4016 OF oDlg ;
            ACTION ( lNew := ! ( lMod := ! lMod ),;
                     oData := oQry:GetBlankRow(), ;
                     oDlg:Update() ) ;
            WHEN ! lNew

   REDEFINE BUTTON ID 4019 OF oDlg ;
            ACTION ( lMod := ! ( lNew := ! lNew ),;
                     oData := oQry:GetRowObj(), ;
                     oData:lAppend := .F.,;
                     oDlg:Update() );
            WHEN ! lMod
            
   REDEFINE BUTTON ID 4017 OF oDlg ;
            ACTION ( lNew := lMod := .F.,;
                     oQry:Refresh(), ;
                     oData := oQry, ;
                     oDlg:Update() );
            WHEN lNew .OR. lMod
   
   REDEFINE BUTTON oBtnSave ID 4018 OF oDlg ;
            ACTION ( oData:Save(),;
                     oData := oQry, ;
                     lNew := lMod := .F.,;
                     oBrw:Refresh(),;
                     oDlg:Update() );
            WHEN lNew .OR. lMod
            
   REDEFINE BUTTON oBtnSave ID 4020 OF oDlg ;
            ACTION ( If( MsgYesNo( "Delete??"),;
                        ( oQry:Delete(),;
                          oBrw:Refresh(),;
                          oDlg:Update() ), ) );
            WHEN ! lNew .OR. ! lMod            
                                              
   REDEFINE XBROWSE oBrw OBJECT oQry AUTOSORT  
    
//   oBrw:SetDolphin( oQry, .T., , {"last_name", "city" }, {|xField, oBrw| SetSetup( xField, oBrw ) } )
   
   oBrw:CreateFromResource( 4015 )
   
   oBrw:bChange = {|| oDlg:Update() }
   
   ACTIVATE DIALOG oDlg CENTERED
   
   oQry:End()

RETURN 

function SetSetup( xField, oBrw )

   local cHeader
   local cCol


   IF Valtype( xField ) == "A" .AND. Len(xField) == 2
      cCol    := xField[1]
      cHeader := xField[2]
   ELSEIF Valtype( xField ) == "A" .AND. Len(xField) # 2
      cCol    := xField[1]
      cHeader := xField[1]
   ELSE
      cCol    := xField
      cHeader := xField
   ENDIF
   oBrw:SetColFromMySQL( cCol, cHeader, .T. )

return nil   
   
//--------------------------------------//

FUNCTION ConnectTo()
   LOCAL hIni      := HB_ReadIni( ".\connect.ini" )
   LOCAL oServer   := NIL
   LOCAL cServer   := hIni["mysql"]["host"],;
         cUser     := hIni["mysql"]["user"],;
         cPassword := hIni["mysql"]["psw"],;
         nPort     := val(hIni["mysql"]["port"]), ;
         cDBName   := hIni["mysql"]["dbname"], ;
         nFlags    := val(hIni["mysql"]["flags"])
   LOCAL oErr
   
   
   
   TRY
   
      oServer = TDolphinSrv():New( cServer, ;
                                cUser, ;
                                cPassword, ;
                                nPort, nFlags, cDBName )
                                
   CATCH oErr 
     RETURN NIL
   END
   
RETURN oServer

//--------------------------------------//


//#include "setbrw.prg"